---
name: frontend-design
description: Create distinctive, production-grade frontend interfaces with high design quality. Use this skill when the user asks to build web components, pages, or applications. Generates creative, polished code that avoids generic AI aesthetics..
---

This skill guides the creation of distinctive, production-ready frontend interfaces, avoiding generic "AI-generated" aesthetic effects. Implement truly functional code with special attention to aesthetic details and creative choices.

Users provide frontend requirements: components, pages, applications, or interfaces to build. They may include context about purpose, audience, or technical constraints.

## Design Thinking

Before coding, understand the context and determine a bold aesthetic direction:
- **Purpose**: What problem does this interface solve? Who will use it?
- **Tone**: Choose an extreme: minimalism, chaotic maximalism, retro-futurism, organic/natural, luxurious/refined, playful/toy-like, magazine/editorial, raw/brutalist, art deco/geometric, soft/pastel, industrial/utilitarian, and so on. Many styles are available. Use these as inspiration, but design a faithful aesthetic direction.
- **Constraints**: Technical requirements (framework, performance, accessibility).
- **Differentiation**: What makes this design memorable? What are the unique features people will remember?

**Key**: Choose a clear conceptual direction and execute precisely. Bold maximalism and refined minimalism can both succeed—the key is intentionality, not intensity level.

Then implement working code (HTML/CSS/JS, React, Vue, etc.) that should:
- Have production-grade quality and functionality
- Be visually striking and memorable
- Maintain consistency with a clear aesthetic viewpoint
- Be meticulously polished in every detail


## Design Styles

The following 5 theme styles are available. Please select the appropriate theme style based on user requirements:

1. **Linear Aesthetic** - Precision, ultra-fine strokes, depth, shimmer, breathing effect, dark mode, glassmorphism
   - Best for: Developer tools, AI technology companies, AI platforms, project management, high-tech SaaS platforms, cryptocurrency exchanges, cryptocurrency/Web3 trading interfaces
   - Reference: `references/themes/linear-aesthetic.md`

2. **Minimalist Modern** - Bold, minimalist-modern visual system with Electric Blue gradients, dual-font pairing, animated graphics, and micro-interactions
   - Best for: Official Website HomePage,Enterprise dashboards, Knowledge bases, Collaboration tools, Payment systems, Documentation, Premium subscription SaaS
   - Reference: `references/themes/minimalist-modern.md`

3. **Apple Minimalist** - Clarity, generous whitespace, high-quality typography, subtle depth, and premium breathable user experience
   - Best for: High-end consumer goods websites, efficiency tools (note-taking, task management) that require high concentration
   - Reference: `references/themes/Apple Minimalist.md`

4. **Cyberpunk** - High contrast neon on black, glitch animations, terminal/monospace fonts, tech-oriented decorations
   - Best for: High-impact marketing sites, gaming communities, crypto/web3 marketing sites, music streaming apps, immersive storytelling experiences
   - Reference: `references/themes/Cyberpunk.md`

5. **Skeuomorphism** - Simulating real-world materials, lighting, and physical textures with tactile depth and materiality
   - Best for: Smart home control panel, professional audio editor, gaming interface
   - Reference: `references/themes/Skeuomorphism.md`


